class ValueContainer(dict):
    def __init__(self):
        dict.__init__(self)

    def merge_from_dict(self, val: dict):
        for key, value in val.items():
            if not key.startswith('__') and not callable(value):
                self[key] = value

    def copy(self):
        copy = ValueContainer()
        copy.merge_from_dict(self)
        return copy

    def __setattr__(self, name, value):
        self[name] = value

    def __getattr__(self, name):
        return self[name]

    def _get_kwargs(self):
        return sorted(self.items())

    def __repr__(self):
        type_name = type(self).__name__
        value_strings = []
        for name, value in self._get_kwargs():
            if name == 'parser':
                continue
            value_strings.append('%s=%r' % (name, value))
        return '%s(%s)' % (type_name, ', '.join(value_strings))