import unittest

from renki.common.conf import ValueContainer


class TestValueContainer(unittest.TestCase):
    def setUp(self):
        self.container = ValueContainer()

    def test_get_set_has(self):
        self.container.key = 'test'
        self.assertTrue(hasattr(self.container, 'key'), 'Expected set() to set the targeted attribute value.')
        self.assertEqual('test', self.container.key, 'The set attribute value did not match to the target value.')
        self.assertEqual('test', self.container['key'], 'Failed to get value by key.')

    def test_merge_from_dict(self):
        self.container.merge_from_dict({
            'key': 'test'
        })
        self.assertTrue(hasattr(self.container, 'key'), 'Expected set() to set the targeted attribute value.')
        self.assertEqual('test', self.container.key, 'The set attribute value did not match to the target value.')
        self.assertEqual('test', self.container['key'], 'Failed to get value by key.')

    def test_repr_should_be_human_readable(self):
        self.container.merge_from_dict({'key': 'test'})
        self.assertEqual('ValueContainer(key=\'test\')', str(self.container), 'str() did not match the expected '
                                                                              'format.')

if __name__ == '__main__':
    unittest.main()
