class RenkiModuleError(Exception):
    pass


def import_authentication_modules(modules):
    imported_modules = []

    if isinstance(modules, str):
        modules = modules.split(',')

    for mod in modules:
        try:
            from_ = '.'.join(mod.split('.')[:-1])
            module_ = mod.split('.')[-1]
            auth_module = __import__(from_, fromlist=[module_])
            imported_modules.append(vars(auth_module)[module_]())
        except ImportError as e:
            raise RenkiModuleError('Cannot import authentication module: %s' % e)

    return imported_modules


def contains_module(modules, module_name):
    for namespace in modules:
        current_module_name = namespace.split('.')[-1]
        if current_module_name == module_name:
            return True
    return False


def import_modules(modules, scope):
    imported_modules = []

    if isinstance(modules, str):
        modules = modules.split(',')

    for namespace in modules:
        if not namespace:
            continue
        try:
            module_root = '.'.join(namespace.split('.')[:-1])
            module_name = namespace.split('.')[-1]
            module = __import__('.'.join([module_root, module_name, scope]), fromlist=['module']).module
            if hasattr(module, 'dependencies'):
                for dependency in module.dependencies:
                    if not contains_module(modules, dependency):
                        raise RenkiModuleError('Missing required dependency: ' + dependency)
            imported_modules.append(module)
        except ImportError as e:
            raise RenkiModuleError('Cannot import renki module: %s' % e)
    return imported_modules
