class ValueContainer:
    values = dict()

    def set(self, key, value):
        key = key.upper()
        self.values[key] = value

    def get(self, key, default=None):
        key = key.upper()
        return self.values.get(key, default)

    def merge_from_dict(self, val: dict):
        for key, value in val.items():
            if not key.startswith('__') and not callable(value):
                if self.__contains__(key) and self.get(key) is not None and value is None:
                    continue
                self.set(key, value)

    def copy(self):
        copy = ValueContainer()
        copy.merge_from_dict(self.values)
        return copy

    def clear(self):
        self.values.clear()

    def __setattr__(self, key, value):
        self.set(key, value)

    def __getattr__(self, key):
        return self.get(key)

    def __delattr__(self, item):
        self.__delitem__(item)

    def __setitem__(self, key, value):
        self.set(key, value)

    def __getitem__(self, key):
        return self.get(key)

    def __delitem__(self, key):
        del self.values[key.upper()]

    def __contains__(self, key):
        return self.values.__contains__(key.upper())

    def _get_kwargs(self):
        return sorted(self.values.items())

    def __repr__(self):
        type_name = type(self).__name__
        value_strings = []
        for key, value in self._get_kwargs():
            value_strings.append('%s=%r' % (key, value))
        return '%s(%s)' % (type_name, ', '.join(value_strings))

    def __del__(self):
        self.values.clear()
