import unittest

from renki.common.conf import ValueContainer


class TestValueContainer(unittest.TestCase):
    def setUp(self):
        self.container = ValueContainer()

    def test_get_set_has(self):
        self.container.KEY = 'test'
        self.assertTrue(hasattr(self.container, 'KEY'), 'Expected set() to set the targeted attribute value.')
        self.assertEqual('test', self.container.KEY, 'The set attribute value did not match to the target value.')
        self.assertEqual('test', self.container['KEY'], 'Failed to get value by KEY.')

    def test_merge_from_dict(self):
        self.container.merge_from_dict({
            'KEY': 'test'
        })
        self.assertTrue(hasattr(self.container, 'KEY'), 'Expected set() to set the targeted attribute value.')
        self.assertEqual('test', self.container.KEY, 'The set attribute value did not match to the target value.')
        self.assertEqual('test', self.container['KEY'], 'Failed to get value by KEY.')

    def test_repr_should_be_human_readable(self):
        self.container.merge_from_dict({'KEY': 'test'})
        self.assertEqual('ValueContainer(KEY=\'test\')', str(self.container), 'str() did not match the expected '
                                                                              'format.')

if __name__ == '__main__':
    unittest.main()
