from renki.core.lib.renkiapi import renkiapi
from renki.core.lib.utils import ok, forbidden
from renki.core.lib.database.basic_tables import Server
from renki.core.lib.auth.basic_permissions import ViewServers
from flask import Blueprint

blueprint = Blueprint('servers', __name__)


@renkiapi('GET', '/servers',
          response={
              'type': 'array',
              'items': {
                  'type': 'object',
                  'properties': {
                      'id': {'type': 'integer'},
                      'name': {'type': 'string'}
                  }
              }
          }, blueprint=blueprint)
def servers_list_servers(identity):
    """
    List all available services

    :param identity: User identity
    """
    if not identity.has_permission(ViewServers):
        return forbidden()

    servers = []

    for server in Server.query.all():
        servers.append({
            'id': server.id,
            'name': server.name
        })

    return ok(servers)


@renkiapi('GET', '/servers/<int:id>',
          url_params={
              'type': 'object',
              'properties': {
                  'id': {'type': 'integer'}
              }
          },
          response={
              'type': 'object',
              'properties': {
                  'id': {'type': 'integer'},
                  'name': {'type': 'string'},
                  'services': {
                      'type': 'array',
                      'items': {
                          'type': 'object',
                          'properties': {
                              'id': {'type': 'integer'},
                              'name': {'type': 'string'},
                              'type': {'type': 'string'}
                          }
                      }
                  }
              }
          }, blueprint=blueprint)
def servers_get_server(identity, data):
    """
    List information of server with id server_id

    :param identity: User identity
    :param data: Data associated with the request
    """
    if not identity.has_permission(ViewServers):
        return forbidden()

    server_id = int(data['id'])

    server = Server.get(server_id)

    services = []
    for service in server.services:
        services.append({
            'id': service.id,
            'name': service.name,
            'type': service.service_type
        })

    return ok({
        'id': server.id,
        'name': server.name,
        'services': services
    })
