import traceback
from renki.core.lib import renki_settings


class RenkiException(Exception):
    def __init__(self, msg):
        self.msg = msg

    def __str__(self):
        return self.msg


class RenkiHTTPError(Exception):
    status_code = 500

    def __init__(self, message, status_code=None, payload=None):
        Exception.__init__(self)
        self.message = message
        if renki_settings.DEBUG is True:
            traceback.print_stack()
            print(message)

        if status_code is not None:
            self.STATUS = status_code

        self.payload = payload

    def to_dict(self):
        data = dict(self.payload or ())
        data['message'] = self.message
        data['status'] = self.status_code

        return data


class Stopped(RenkiException):
    pass


class Invalid(RenkiHTTPError):
    STATUS = 400
    pass


class InvalidRequest(RenkiHTTPError):
    STATUS = 400
    pass


class InvalidType(RenkiHTTPError):
    STATUS = 400
    pass


class DatabaseError(RenkiHTTPError):
    STATUS = 400
    pass


class AlreadyExist(RenkiHTTPError):
    STATUS = 409
    pass


class DoesNotExist(RenkiHTTPError):
    STATUS = 404
    pass


class AuthenticationFailed(RenkiHTTPError):
    STATUS = 401
    pass


class PermissionDenied(RenkiHTTPError):
    STATUS = 403
    pass


class SoftLimitReached(RenkiException):
    pass


class HardLimitReached(RenkiException):
    pass


class RenkiBug(RenkiException):
    pass


class RenkiInvalidType(RenkiException):
    pass


class NoMemberSelected(RenkiException):
    pass


class NoUnixUserFound(RenkiException):
    pass


class MultipleUnixUsersFound(RenkiException):
    pass
