import logging
from renki.core.lib.database.table import db, migrate
from renki.core.lib.history_meta import versioned_session
from renki.core.routes import default_routes, login_routes, session_routes, ticket_routes, server_routes, service_routes
from renki.core.routes.permission import permission_routes, user_member_permission_group_routes,\
    user_permission_group_routes, member_permission_group_routes
from renki.core.routes.user_management import user_routes, user_member_routes, member_routes
from renki.core.lib.renkiapi import spec_blueprint
from renki.core.routes.default_routes import setup_error_handlers
from renki.core.lib import blueprints
from flask import Flask, Blueprint
from flask.ext.sqlalchemy import SignallingSession


class DefaultConfig:
    LOG_FILE = None
    LOG_LEVEL = logging.DEBUG
    SQLALCHEMY_DATABASE_URI = 'sqlite://'
    AUTO_CREATE_TABLES = True
    MODULE_BLUEPRINTS = blueprints.BLUEPRINTS


def register_default_blueprints(app):
    app.register_blueprint(default_routes.blueprint)
    app.register_blueprint(login_routes.blueprint)
    app.register_blueprint(session_routes.blueprint)
    app.register_blueprint(permission_routes.blueprint)
    app.register_blueprint(user_permission_group_routes.blueprint)
    app.register_blueprint(user_member_permission_group_routes.blueprint)
    app.register_blueprint(member_permission_group_routes.blueprint)
    app.register_blueprint(user_routes.blueprint)
    app.register_blueprint(member_routes.blueprint)
    app.register_blueprint(user_member_routes.blueprint)
    app.register_blueprint(ticket_routes.blueprint)
    app.register_blueprint(spec_blueprint)
    app.register_blueprint(service_routes.blueprint)
    app.register_blueprint(server_routes.blueprint)


def register_module_blueprints(app):
    if 'MODULE_BLUEPRINTS' not in app.config:
        return

    for blueprint in app.config['MODULE_BLUEPRINTS']:
        if isinstance(blueprint, Blueprint):
            app.register_blueprint(blueprint)


def create_app(config=None, config_file=None):
    app = Flask(__name__)
    app.config.from_object(DefaultConfig)

    if config is not None:
        app.config.update(**config)

    if app.config['AUTO_CREATE_TABLES']:
        @app.before_first_request
        def create_db():
            db.create_all()

    if config_file is not None:
        app.config.from_pyfile(config_file)

    app.logger_name = 'renki_core'
    handler = logging.FileHandler(app.config['LOG_FILE']) if app.config['LOG_FILE'] else logging.StreamHandler()
    handler.setLevel(app.config['LOG_LEVEL'])
    app.logger.setLevel(app.config['LOG_LEVEL'])
    app.logger.addHandler(handler)

    db.init_app(app)
    migrate.init_app(app, db)

    versioned_session(SignallingSession)

    register_default_blueprints(app)
    register_module_blueprints(app)

    setup_error_handlers(app)

    return app
