#!/usr/bin/env python

import os
from flask.ext.script import Manager, prompt_bool
from flask.ext.script.commands import InvalidCommand

from renki.core.lib import check_settings
from renki.core.lib.commands.permission_group_command import permission_group_manager
from renki.core.lib.commands.server_command import server_manager
from renki.core.lib.commands.service_command import service_manager
from renki.core.lib.database.table import db
from renki.core.lib.renki_app import create_app
from renki.core.lib.commands import permission_command
from renki.core.lib.commands import user_command
from renki.core.lib.database import migrations

check_settings.set_settings()

default_settings_file = os.path.abspath(os.path.join(os.path.dirname(__file__), 'settings.py'))

manager = Manager(create_app)
manager.add_option('-c', '--config', dest='config_file', default=default_settings_file, required=False)

db_manager = Manager(usage="Manage database")


@db_manager.command
def make_migrations(name, comment=''):
    migrations.make_migrations(name, comment, db.engine, db.metadata)


@db_manager.command
def run_migrations(module=None, target_version=None):
    migrations.run_migrations(db, module, target_version)


# Add database manager to manager
manager.add_command("db", db_manager)

# Add user manager to manager
user_command.create_commands()
manager.add_command("user", user_command.user_manager)

# Add permission manager to manager
manager.add_command("permission", permission_command.permission_manager)

# Add permission group manager
manager.add_command("group", permission_group_manager)

# Add service manager
manager.add_command("service", service_manager)

# Add server manager
manager.add_command("server", server_manager)

# TODO: managers for
# * User to Member
#   * add
#   * list
#   * remove

def main():
    import sys
    try:
        manager.run()
    except InvalidCommand as err:
        print("ERROR: %s" % err, file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
