"""
This settings module is dynamically populated by lib.check_settings.
"""

import os

LOGGING = {
    'version': 1,
    'disable_existing_loggers': True,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
        },
        'simple': {
            '()': 'logging.Formatter',
            'format': '%(asctime)-20s %(levelname)s %(module)s %(message)s'
        }
    },
    'filters': {
    },
    'handlers': {
        'null': {
            'level': 'DEBUG',
            'class': 'logging.NullHandler',
        },
        'console': {
            'class': 'logging.StreamHandler',
            'formatter': 'verbose'
        }
    },
    'loggers': {
        'server': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
        'admin': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
        'login_routes': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
        'create_tables': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
        'dbconnection': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'Authentication': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'BasicAuthentication': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'auth.db': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'utils': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'ticket': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'INFO',
        },
        'module_database': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'module_dns_zone': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'module_domain': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'module_port': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'module_repository': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'tickets_done': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'permission_group_command': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'permission_command': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'command_utils': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'service_command': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'development_data': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
        'migrations': {
            'handlers': ['console'],
            'propagate': True,
            'level': 'DEBUG',
        },
    }
}
