# Renki migrations - generated by Renki 0.0.1 on 2016-06-22 20:14:43.953263
# initial : Create initial tables
import sqlalchemy as sa
import sqlalchemy_utils.types as ext

version = 1


def upgrade(op):
    op.create_table('basic_auth_users',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('password', sa.Unicode(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('default_limits',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('table', sa.Unicode(), nullable=False),
                    sa.Column('soft_limit', sa.Integer(), nullable=True),
                    sa.Column('hard_limit', sa.Integer(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('limits',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('type', sa.Unicode(), nullable=True),
                    sa.Column('table', sa.Unicode(), nullable=False),
                    sa.Column('soft_limit', sa.Integer(), nullable=True),
                    sa.Column('hard_limit', sa.Integer(), nullable=True),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('member_permission_groups',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('description', sa.Unicode(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('members',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('meta',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('variable', sa.String(), nullable=False),
                    sa.Column('int_value', sa.Integer(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('servers',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('comment', sa.String(), nullable=False),
                    sa.Column('deleted', sa.Integer(), nullable=True),
                    sa.Column('timestamp', sa.DateTime(), nullable=False),
                    sa.Column('name', sa.String(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('services',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('comment', sa.String(), nullable=False),
                    sa.Column('deleted', sa.Integer(), nullable=True),
                    sa.Column('timestamp', sa.DateTime(), nullable=False),
                    sa.Column('name', sa.String(), nullable=False),
                    sa.Column('service_type', sa.String(), nullable=True),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('ticket_groups',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('comment', sa.String(), nullable=False),
                    sa.Column('deleted', sa.Integer(), nullable=True),
                    sa.Column('timestamp', sa.DateTime(), nullable=False),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('user_member_permission_groups',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('description', sa.Unicode(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('user_permission_groups',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('description', sa.Unicode(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('users',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('added', sa.DateTime(), nullable=True),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('auth_module', sa.Unicode(), nullable=False),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name', 'auth_module')
                    )
    op.create_table('auth_tokens',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('token', sa.Unicode(), nullable=False),
                    sa.Column('expires', sa.DateTime(), nullable=False),
                    sa.Column('user_id', sa.Integer(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('member_limits',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['id'], ['limits.id'], ),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('member_to_member_permission_groups',
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.Column('member_permission_group_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.ForeignKeyConstraint(['member_permission_group_id'], ['member_permission_groups.id'], )
                    )
    op.create_table('permissions',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('description', sa.Unicode(), nullable=False),
                    sa.Column('service_id', sa.Integer(), nullable=True),
                    sa.Column('is_global', sa.Boolean(), nullable=True),
                    sa.ForeignKeyConstraint(['service_id'], ['services.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name', 'service_id')
                    )
    op.create_table('services_to_servers',
                    sa.Column('service_id', sa.Integer(), nullable=True),
                    sa.Column('server_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['server_id'], ['servers.id'], ),
                    sa.ForeignKeyConstraint(['service_id'], ['services.id'], )
                    )
    op.create_table('tickets',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('comment', sa.String(), nullable=False),
                    sa.Column('deleted', sa.Integer(), nullable=True),
                    sa.Column('timestamp', sa.DateTime(), nullable=False),
                    sa.Column('ticket_type', sa.Unicode(), nullable=False),
                    sa.Column('ticket_module', sa.Unicode(), nullable=True),
                    sa.Column('new_data', ext.JSONType(), nullable=True),
                    sa.Column('old_data', ext.JSONType(), nullable=True),
                    sa.Column('created', sa.DateTime(), nullable=True),
                    sa.Column('acquired', sa.DateTime(), nullable=True),
                    sa.Column('done', sa.DateTime(), nullable=True),
                    sa.Column('failed', sa.DateTime(), nullable=True),
                    sa.Column('error', sa.Unicode(), nullable=True),
                    sa.Column('server_id', sa.Integer(), nullable=False),
                    sa.Column('ticket_group_id', sa.Integer(), nullable=False),
                    sa.ForeignKeyConstraint(['server_id'], ['servers.id'], ),
                    sa.ForeignKeyConstraint(['ticket_group_id'], ['ticket_groups.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('user_to_user_permission_group',
                    sa.Column('user_id', sa.Integer(), nullable=True),
                    sa.Column('user_permission_group_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
                    sa.ForeignKeyConstraint(['user_permission_group_id'], ['user_permission_groups.id'], )
                    )
    op.create_table('users_to_members',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('user_id', sa.Integer(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=False),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.ForeignKeyConstraint(['user_id'], ['users.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('user_id', 'member_id')
                    )
    op.create_table('member_permission_groups_to_permissions',
                    sa.Column('member_permission_group_id', sa.Integer(), nullable=True),
                    sa.Column('permission_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['member_permission_group_id'], ['member_permission_groups.id'], ),
                    sa.ForeignKeyConstraint(['permission_id'], ['permissions.id'], )
                    )
    op.create_table('member_tickets',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['id'], ['tickets.id'], ),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )
    op.create_table('user_member_permission_groups_to_permissions',
                    sa.Column('user_member_permission_group_id', sa.Integer(), nullable=True),
                    sa.Column('permission_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['permission_id'], ['permissions.id'], ),
                    sa.ForeignKeyConstraint(['user_member_permission_group_id'], ['user_member_permission_groups.id'], )
                    )
    op.create_table('user_member_to_user_member_permission_group',
                    sa.Column('users_to_member_id', sa.Integer(), nullable=True),
                    sa.Column('user_member_permission_group_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['user_member_permission_group_id'], [
                                            'user_member_permission_groups.id'], ),
                    sa.ForeignKeyConstraint(['users_to_member_id'], ['users_to_members.id'], )
                    )
    op.create_table('user_permission_groups_to_permissions',
                    sa.Column('user_permission_group_id', sa.Integer(), nullable=True),
                    sa.Column('permission_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['permission_id'], ['permissions.id'], ),
                    sa.ForeignKeyConstraint(['user_permission_group_id'], ['user_permission_groups.id'], )
                    )


def downgrade(op):
    op.drop_table('user_permission_groups_to_permissions')
    op.drop_table('user_member_to_user_member_permission_group')
    op.drop_table('user_member_permission_groups_to_permissions')
    op.drop_table('member_tickets')
    op.drop_table('member_permission_groups_to_permissions')
    op.drop_table('users_to_members')
    op.drop_table('user_to_user_permission_group')
    op.drop_table('tickets')
    op.drop_table('services_to_servers')
    op.drop_table('permissions')
    op.drop_table('member_to_member_permission_groups')
    op.drop_table('member_limits')
    op.drop_table('auth_tokens')
    op.drop_table('users')
    op.drop_table('user_permission_groups')
    op.drop_table('user_member_permission_groups')
    op.drop_table('ticket_groups')
    op.drop_table('services')
    op.drop_table('servers')
    op.drop_table('meta')
    op.drop_table('members')
    op.drop_table('member_permission_groups')
    op.drop_table('limits')
    op.drop_table('default_limits')
    op.drop_table('basic_auth_users')
