from renki.core.lib.test_utils import BasicTest
from renki.core.lib.auth.authentication_modules.basic import BasicAuthenticationModule
from renki.core.lib.database.table import db
import unittest


class GenericTest(BasicTest):
    def setUp(self):
        super(GenericTest, self).setUp()

        self._basic_user_1 = BasicAuthenticationModule.register_user('basic1', 'basic1')
        db.session.commit()


class TestIndexRoute(GenericTest):
    """
    Test / route
    """

    def setUp(self):
        super(TestIndexRoute, self).setUp()

    def test_root_get_anon(self):
        """
        Test GET / route as anonymous
        """
        self.get('/')

    def test_root_get_user(self):
        """
        Test GET / route as user
        """
        self.auth('basic1', 'basic1')
        self.get('/')


class TestVersionRoute(GenericTest):
    """
    Test /version route
    """

    def setUp(self):
        super(TestVersionRoute, self).setUp()

    def test_version_get_anon(self):
        """
        Test GET /version route as anonymous
        """
        self.get('/version')

    def test_version_get_user(self):
        """
        Test GET /version route as user
        """
        self.auth('basic1', 'basic1')
        self.get('/version')


class TestErrorRoute(GenericTest):
    """
    Test /error route
    """

    def setUp(self):
        super(TestErrorRoute, self).setUp()

    def test_error_get_anon(self):
        """
        Test GET /version route as anonymous
        """
        assert self.get('/error', expect_errors=True).status_int == 400

    def test_error_get_user(self):
        """
        Test GET /version route as user
        """
        self.auth('basic1', 'basic1')
        assert self.get('/error', expect_errors=True).status_int == 400

    def test_error_post_anon(self):
        """
        Test POST /version route as anonymous
        """
        assert self.post('/error', expect_errors=True).status_int == 400

    def test_error_post_user(self):
        """
        Test POST /version route as user
        """
        self.auth('basic1', 'basic1')
        assert self.post('/error', expect_errors=True).status_int == 400

    def test_error_put_anon(self):
        """
        Test PUT /version route as anonymous
        """
        assert self.put('/error', expect_errors=True).status_int == 400

    def test_error_put_user(self):
        """
        Test PUT /version route as user
        """
        self.auth('basic1', 'basic1')
        assert self.put('/error', expect_errors=True).status_int == 400

    def test_error_delete_anon(self):
        """
        Test DELETE /version route as anonymous
        """
        assert self.delete('/error', expect_errors=True).status_int == 400

    def test_error_delete_user(self):
        """
        Test DELETE /version route as user
        """
        self.auth('basic1', 'basic1')
        assert self.delete('/error', expect_errors=True).status_int == 400


class TestInvalidRequest(GenericTest):
    """
    Test routes with invalid requests
    """

    def setUp(self):
        super(TestInvalidRequest, self).setUp()

    def test_post_invalid_route(self):
        """
        Verify that the API returns HTTP 400 when the request is missing required properties
        """
        assert self.post('/login', expect_errors=True).status_int == 400


if __name__ == "__main__":
    unittest.main()
