from renki.core.lib.auth.db import UserPermissionGroup, Permission
from renki.core.lib.auth.permissions import GlobalPermission, ServicePermission
from renki.core.lib.test_utils import BasicTest
from renki.core.lib.commands import permission_group_command, command_utils
from renki.core.lib.database.table import db

__unittest = True

TestGlobalPermission = GlobalPermission('test_global_permission', 'Test global permission')
TestServicePermission = ServicePermission('test_service_permission', 'Test Service permission')

"""
Partial test for management commands
Waiting for fixtures.
"""


class TestUserPermissionGroupCommand(BasicTest):
    """
    Test user permission group
    """

    def setUp(self):
        super(TestUserPermissionGroupCommand, self).setUp()
        self.group_name = "testgroup"
        self.group_description = "Testing"

    def get_groups_by_name(self, name):
        return UserPermissionGroup().query.filter(UserPermissionGroup.name == name).all()

    def get_permission_by_name(self, name):
        return Permission().query.filter(Permission.name == name).one()

    def get_group(self, name):
        return UserPermissionGroup().query.filter(UserPermissionGroup.name == name).one()

    def add_group(self, name, description):
        permission_group_command.AddUserPermissionGroup().run(name=name, description=description)

    def add_permission(self, group, permission):
        group.permissions.append(permission)
        group.save()
        db.session.commit()

    def test_add_new_user_permission_group(self):
        self.assertTrue(len(self.get_groups_by_name(self.group_name)) == 0, "Group already created")
        permission_group_command.AddUserPermissionGroup().run(name=self.group_name, description=self.group_description)
        self.assertTrue(len(self.get_groups_by_name(self.group_name)) == 1, "Group not created")

    def test_remove_user_permission_group(self):
        self.add_group(self.group_name, self.group_description)
        self.assertTrue(len(self.get_groups_by_name(self.group_name)) == 1, "Group not created")
        permission_group_command.RemoveUserPermissionGroup().run(name=self.group_name)
        self.assertTrue(len(self.get_groups_by_name(self.group_name)) == 0, "Group not removed")

    def test_add_global_permission(self):
        command_utils.sync_global_permissions()
        self.add_group(self.group_name, self.group_description)
        permission = self.get_permission_by_name(TestGlobalPermission.name)
        permission_group_command.UserPermissionGroupAddPermission().run(self.group_name, TestGlobalPermission.name,
                                                                        None)
        g = self.get_group(self.group_name)
        self.assertTrue(permission in g.permissions, "Permission not added to group")

    def test_remove_global_permission(self):
        command_utils.sync_global_permissions()
        self.add_group(self.group_name, self.group_description)
        permission = self.get_permission_by_name(TestGlobalPermission.name)
        group = self.get_group(self.group_name)
        self.add_permission(group, permission)
        group = self.get_group(self.group_name)
        self.assertTrue(permission in group.permissions, "Permission not added to group")
        permission_group_command.UserPermissionGroupRemovePermission().run(self.group_name, TestGlobalPermission.name,
                                                                           None)
        self.assertTrue(permission not in group.permissions, "Permission not removed from group")
