from renki.core.lib.renkiapi import renkiapi, reset_route_specification, route_specifications
from renki.core.lib import exceptions
import unittest

from renki.core.context import settings

settings.DEBUG = False


def route_no_parameters():
    pass


def route_only_identity(identity):
    _ = identity
    pass


def route_only_data(data):
    _ = data
    pass


def route_identity_and_data(identity, data):
    _ = identity
    _ = data
    pass


class TestApispecDecoratorGET(unittest.TestCase):
    def setUp(self):
        reset_route_specification()

    def tearDown(self):
        reset_route_specification()

    def test_apispec(self):
        renkiapi('GET', '/foo')(route_no_parameters)
        self.assertTrue('/foo' in route_specifications, 'Specifications should be saved')

    def test_invalid_method(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('TEST', '/foo')(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('PATCH', '/foo')(route_no_parameters)

    def test_no_paths(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET')(route_no_parameters)

    def test_invalid_path(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', 'path')(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', 15)(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', ['/path1', 'path'])(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', ['/path1', 123])(route_no_parameters)

    def test_invalid_get_schema(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', '/foo', url_params=15)(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('GET', '/foo', url_params={'type': str})(route_no_parameters)

    def test_invalid_json_schema(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('POST', '/foo', json=15)(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('POST', '/foo', json={'type': int})

    def test_invalid_response_schema(self):
        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('POST', '/foo', response=15)(route_no_parameters)

        with self.assertRaises(exceptions.RenkiBug):
            renkiapi('POST', '/foo', response={'type': int})(route_no_parameters)


class TestRenkiApiAuthentication(unittest.TestCase):
    def setUp(self):
        reset_route_specification()

    def tearDown(self):
        reset_route_specification()

    def test_no_get_schema(self):
        renkiapi('GET', '/foo')(route_no_parameters)

    def test_no_auth_token_defined(self):
        renkiapi('GET', '/foo', url_params={})

    def test_auth_missing_auth_token_required(self):
        renkiapi('GET', '/foo', url_params={'type': 'object',
                                            'properties': {
                                                'name': {'type': 'string'}
                                            },
                                            'required': ['name']
                                            })

if __name__ == '__main__':
    unittest.main()
