from renki.common.utilities.settings import Settings
from renki.common.utilities.module_loader import import_modules, import_authentication_modules

settings = Settings(
    (['-d', '--debug'], {'type': bool, 'default': False, 'help': 'Set this true to enable debugging mode.'}),
    (['-h', '--host'], {'type': str, 'required': True, 'default': 'localhost',
                        'help': 'Hostname for the server to bind to.'}),
    (['-p', '--port'], {'type': int, 'required': True, 'default': 8080, 'help': 'Port for the server to bind to.'}),
    (['-m', '--modules'], {'type': str, 'required': True, 'help': 'Renki modules to load.'}),
    (['-a', '--authentication-modules'], {'type': str, 'required': True,
                                          'help': 'Authentication modules to load.'}),
    (['--connection-string'], {'type': str, 'required': True, 'help': 'Database connection string.'}),
    (['--key-expire-time'], {'type': int, 'required': True, 'default': 86400,
                             'help': 'Lifetime before authentication token expiration.'}),
    (['--auth-secret'], {'type': str, 'required': True, 'help': 'Secret used to secure authentication sessions.'})
)
