from renki.core.lib.database.table import RenkiDataTable
from renki.core.lib.database.tables import register_table
from renki.core.lib.database.basic_tables import Server
from renki.core.lib.auth.db import Member
from sqlalchemy import Column, Integer, ForeignKey, DateTime, func, Unicode
from sqlalchemy.orm import relationship
from sqlalchemy_utils.types import JSONType


class TicketGroup(RenkiDataTable):
    __tablename__ = 'ticket_groups'

    def validate(self):
        return True

register_table(TicketGroup)


class Ticket(RenkiDataTable):
    __tablename__ = 'tickets'
    ticket_type = Column('ticket_type', Unicode, nullable=False)
    ticket_module = Column('ticket_module', Unicode, nullable=True)
    new_data = Column(JSONType, nullable=True)
    old_data = Column(JSONType, nullable=True)
    created = Column('created', DateTime, default=func.now())
    acquired = Column('acquired', DateTime, nullable=True)
    done = Column('done', DateTime, nullable=True)
    failed = Column('failed', DateTime, nullable=True)
    error = Column('error', Unicode, nullable=True)
    server_id = Column(Integer, ForeignKey('servers.id'), nullable=False)
    server = relationship(Server, backref='tickets')
    ticket_group_id = Column(Integer, ForeignKey('ticket_groups.id'), nullable=False)
    ticket_group = relationship(TicketGroup, backref='tickets')

    __mapper_args__ = {
        'polymorphic_identity': 'ticket',
        'polymorphic_on': ticket_type
    }

    def validate(self):
        return True

register_table(Ticket)


class MemberTicket(Ticket):
    __tablename__ = 'member_tickets'
    id = Column(Integer, ForeignKey('tickets.id'), primary_key=True)
    member_id = Column(Integer, ForeignKey('members.id'), nullable=True)
    member = relationship(Member, backref='tickets')

    __mapper_args__ = {
        'polymorphic_identity': 'member_tickets',
    }

register_table(MemberTicket)
