from renki.core.lib.database.table import RenkiDataTable, RenkiTable, db
from renki.core.lib.database.tables import register_table
from sqlalchemy import Column, String, Integer, ForeignKey, UniqueConstraint
from sqlalchemy.orm import relationship

services_to_servers = db.Table('services_to_servers',
                               Column('service_id', Integer, ForeignKey('services.id')),
                               Column('server_id', Integer, ForeignKey('servers.id')))


class Server(RenkiDataTable):
    __tablename__ = 'servers'
    name = Column('name', String, nullable=False)
    __table_args__ = (UniqueConstraint('name'),)

    def validate(self):
        return True

register_table(Server)


class Service(RenkiDataTable):
    __tablename__ = 'services'
    name = Column('name', String, nullable=False)
    service_type = Column('service_type', String)
    servers = relationship('Server', secondary=services_to_servers, backref='services')

    __table_args__ = (UniqueConstraint('name'),)

    def validate(self):
        return True

register_table(Service)


class Meta(RenkiTable):
    __tablename__ = 'meta'
    variable = Column('variable', String, nullable=False)
    int_value = Column('int_value', Integer, nullable=False)

    def validate(self):
        return True

register_table(Meta)
