from flask import Blueprint
from renki.core.lib.renkiapi import renkiapi
from renki.core.lib.utils import ok, forbidden
from renki.core.context import settings
from renki.core.lib.exceptions import AuthenticationFailed

import logging
logger = logging.getLogger('login_routes')

blueprint = Blueprint('login', __name__)


@renkiapi('GET', '/login/valid',
          url_params={
              'type': 'object',
              'properties': {
                  'auth_token': {'type': 'string'}
              },
              'required': ['auth_token'],
              'additionalProperties': False
          },
          response={
              'type': 'object',
              'properties': {
                  'message': {'type': 'string'}
              }
          },
          require_authentication=False, blueprint=blueprint)
def login_valid(data):
    """
    Test if authentication token is still valid.
    :param data: Data associated with the request
    """
    # TODO : check from identity
    auth_token = data['auth_token']

    for mod in settings.authentication_modules:
        if mod.valid_key(auth_token):
            return ok({'message': 'Token is valid'})
    return ok({'message': 'Token is not valid'})


@renkiapi('POST', '/login',
          json={
              'type': 'object',
              'properties': {
                  'username': {'type': 'string'},
                  'password': {'type': 'string'}
              },
              'required': ['username', 'password']
          },
          response={
              'type': 'object',
              'properties': {
                  'authToken': {'type': 'string'}
              }
          },
          require_authentication=False, blueprint=blueprint)
def login_route(data):
    """
    Login to API.
    :param data: Data associated with the request
    """
    username = data['username']
    password = data['password']
    for mod in settings.authentication_modules:
        try:
            identity = mod.authenticate(username=username, password=password)
            logger.info('User %s has successfully authenticated' % username)
            return ok(identity)
        except AuthenticationFailed:
            logger.info('User %s failed to authenticate against %s' % (username, mod))
            pass

    return forbidden('Authentication failed')
