from renki.core.lib.communication.ticket_tables import TicketGroup, Ticket
from renki.core.lib.database.basic_tables import Service
from renki.core.lib.auth.db import Member
from renki.core.lib.database.table import db
import logging

logger = logging.getLogger('ticket')


def create_ticket_member(member_data_table):
    ticket_group = TicketGroup()
    ticket_group.save(commit=False)

    member_data_table.ticket_group = ticket_group
    member_data_table.real_save(commit=False)
    db.session.flush()

    member = Member.get(member_data_table.member_id)

    service_id = member_data_table.get_service_id()
    ticket_type = member_data_table.get_ticket_type()

    new_data = member_data_table.as_dict()

    history = member_data_table.__history_mapper__.class_

    old_data = history.query.filter(history.id == member_data_table.id).order_by(history.version.desc()).first()
    if old_data:
        tmp = old_data.to_dict()
        old_data = {k: tmp[k] for k in member_data_table.as_dict().keys()}

    service = Service.query.filter(Service.id == service_id).one()

    for server in service.servers:
        ticket = Ticket()
        ticket.old_data = old_data
        ticket.new_data = new_data
        ticket.ticket_group_id = ticket_group.id
        ticket.server = server
        ticket.ticket_type = ticket_type
        if member is not None:
            ticket.member = member
        ticket.save()


def create_delete_ticket_member(member_data_table):
    ticket_group = TicketGroup()
    ticket_group.save()
    db.session.flush()

    service_id = member_data_table.get_service_id()
    ticket_type = member_data_table.get_ticket_type()

    member = Member.get(member_data_table.member_id)

    service = Service.query.filter(Service.id == service_id).one()
    for server in service.servers:
        ticket = Ticket()
        ticket.old_data = member_data_table.as_dict()
        ticket.new_data = None
        ticket.ticket_group_id = ticket_group.id
        ticket.server = server
        ticket.ticket_type = ticket_type
        if member is not None:
            ticket.member = member
        ticket.save()
