from renki.common.utilities.settings import Settings

from renki.common.conf import SchemaField

settings = Settings(
    SchemaField('debug',
                flags=['-d', '--debug'],
                action='store_true',
                default=False,
                help='Switch to enable debugging mode'),
    SchemaField('host',
                flag=['-h', '--host'],
                type=str,
                default='localhost',
                help='Hostname for the server socket bind'),
    SchemaField('port',
                flag=['-p', '--port'],
                type=int,
                default=8080,
                help='Port for the server socket bind'),
    SchemaField('modules',
                flag=['-m', '--modules'],
                type=list,
                reuired=True,
                help='List of modules to load'),
    SchemaField('auth_modules',
                flag=['-a', '--auth-modules'],
                type=list,
                required=True,
                help='Authentication modules to configure'),
    SchemaField('connection_string',
                flag=['-d', '--connection-string'],
                type=str,
                required=True,
                help='Database connection string'),
    SchemaField('key_expire_time',
                flag=['--key-expire-time'],
                type=int,
                default=86400,
                required=True,
                help='Authentication token expiration delay'),
    SchemaField('secret',
                flag=['--secret'],
                type=str,
                required=True,
                help='Encryption secret'),
)
