from flask.ext.script.commands import InvalidCommand

from renki.core.lib.commands.command_utils import *
from renki.core.lib.auth.basic_permissions import ChangePassword, ViewPersonalData, EditPersonalData, SrvFetchTickets,\
    ViewUserPermissionGroups, ViewMemberPermissionGroups, ViewUserMemberPermissionGroups, EditUserPermissionGroups,\
    EditMemberPermissionGroups, EditUserMemberPermissionGroups, ViewPermissions, EditPermissions, ViewUsers, EditUsers,\
    ViewMembers, EditMembers, ViewUserMembers, EditUserMembers, ViewServers, ViewServices
from renki.core.lib.database.table import db
from renki.modules.dummy.core.dummy_routes import ViewDummies, EditDummies, AdministerDummies
from renki.modules.port.core.port_routes import ViewPorts, EditPorts
from renki.modules.unix_user.core.unix_user_routes import EditUnixUsers, ViewUnixUsers

import logging

logger = logging.getLogger("development_data")


def setup_development_data():
    """
    Setup development data
    :return:
    """

    if len(get_users()) > 0:
        raise InvalidCommand("Database is not empty, stubbornly refusing to add development data")

    logger.info('Creating users and members')

    super_admin = get_or_create_user('super_admin', 'super_admin')
    admin = get_or_create_user('admin', 'admin')
    test = get_or_create_user('test', 'test')
    paskanmarja = get_or_create_user('srv_paskanmarja', 'srv_paskanmarja')

    kapsi_member = get_or_create_member(0)
    normal_member = get_or_create_member(1)

    super_admin.save()
    admin.save()
    test.save()
    paskanmarja.save()
    kapsi_member.save()
    normal_member.save()

    logger.info('Setting up needed permissions')

    srv_paskanmarja = get_or_create_server('Paskanmarja')
    paskanmarja_dummy = get_or_create_service('Paskanmarja_dummies', 'dummies', [srv_paskanmarja])
    paskanmarja_ports = get_or_create_service('Paskanmarja_ports', 'ports', [srv_paskanmarja])

    perm_view_user_permission_groups = get_or_create_global_permission(ViewUserPermissionGroups)
    perm_view_member_permission_groups = get_or_create_global_permission(ViewMemberPermissionGroups)
    perm_view_user_member_permission_groups = get_or_create_global_permission(ViewUserMemberPermissionGroups)

    perm_modify_user_permission_groups = get_or_create_global_permission(EditUserPermissionGroups)
    perm_modify_member_permission_groups = get_or_create_global_permission(EditMemberPermissionGroups)
    perm_modify_user_member_permission_groups = get_or_create_global_permission(EditUserMemberPermissionGroups)

    perm_view_permissions = get_or_create_global_permission(ViewPermissions)
    perm_modify_permissions = get_or_create_global_permission(EditPermissions)

    perm_change_password = get_or_create_global_permission(ChangePassword)
    perm_srv_fetch_tickets = get_or_create_global_permission(SrvFetchTickets)
    perm_view_personal_data = get_or_create_global_permission(ViewPersonalData)
    perm_modify_personal_data = get_or_create_global_permission(EditPersonalData)

    perm_view_paskanmarja_dummies = get_or_create_service_permission(ViewDummies, 'View own dummies in paskanmarja',
                                                                     paskanmarja_dummy)
    perm_edit_paskanmarja_dummies = get_or_create_service_permission(EditDummies, 'Edit dummies in paskanmarja',
                                                                     paskanmarja_dummy)
    perm_administer_paskanmarja_dummies = get_or_create_service_permission(AdministerDummies, 'Administer dummies',
                                                                           paskanmarja_dummy)

    perm_view_ports = get_or_create_global_permission(ViewPorts)
    perm_edit_paskanmarja_ports = get_or_create_service_permission(EditPorts, 'Edit ports in paskanmarja',
                                                                   paskanmarja_ports)

    perm_view_users = get_or_create_global_permission(ViewUsers)
    perm_edit_users = get_or_create_global_permission(EditUsers)

    perm_view_members = get_or_create_global_permission(ViewMembers)
    perm_edit_members = get_or_create_global_permission(EditMembers)

    perm_view_user_members = get_or_create_global_permission(ViewUserMembers)
    perm_edit_user_members = get_or_create_global_permission(EditUserMembers)

    perm_view_servers = get_or_create_global_permission(ViewServers)
    perm_view_services = get_or_create_global_permission(ViewServices)

    perm_view_unix_users = get_or_create_global_permission(ViewUnixUsers)
    perm_edit_unix_users = get_or_create_global_permission(EditUnixUsers)

    normal_user_member = get_or_create_user_member(user=test, member=normal_member)

    normal_member_group = get_or_create_member_permission_group('member')
    normal_member_group.add_member(normal_member)
    normal_member_group.add_permission(perm_view_personal_data)
    normal_member_group.add_permission(perm_modify_personal_data)
    normal_member_group.add_permission(perm_view_paskanmarja_dummies)
    normal_member_group.add_permission(perm_edit_paskanmarja_dummies)
    normal_member_group.add_permission(perm_view_ports)
    normal_member_group.add_permission(perm_edit_paskanmarja_ports)

    admins = get_or_create_user_permission_group('admin')
    normal = get_or_create_user_permission_group('user')
    servers = get_or_create_user_permission_group('renkisrv')

    # Add users to groups
    normal.add_user(test)
    normal.add_permission(perm_change_password)
    normal.add_permission(perm_view_servers)
    normal.add_permission(perm_view_services)

    admins.add_user(admin)
    admins.add_permission(perm_change_password)
    admins.add_permission(perm_view_permissions)
    admins.add_permission(perm_modify_permissions)
    admins.add_permission(perm_view_user_permission_groups)
    admins.add_permission(perm_view_member_permission_groups)
    admins.add_permission(perm_view_user_member_permission_groups)
    admins.add_permission(perm_modify_user_permission_groups)
    admins.add_permission(perm_modify_member_permission_groups)
    admins.add_permission(perm_modify_user_member_permission_groups)
    admins.add_permission(perm_view_users)
    admins.add_permission(perm_edit_users)
    admins.add_permission(perm_view_members)
    admins.add_permission(perm_edit_members)
    admins.add_permission(perm_view_user_members)
    admins.add_permission(perm_edit_user_members)
    admins.add_permission(perm_view_ports)
    admins.add_permission(perm_edit_paskanmarja_ports)
    admins.add_permission(perm_view_servers)
    admins.add_permission(perm_view_services)
    admins.add_permission(perm_administer_paskanmarja_dummies)
    admins.add_permission(perm_view_unix_users)
    admins.add_permission(perm_edit_unix_users)

    servers.add_user(paskanmarja)
    servers.add_permission(perm_srv_fetch_tickets)

    normal_user_member_group = get_or_create_user_member_group("normal")
    normal_user_member_group.add_user_member(normal_user_member)
    normal_user_member_group.add_permission(perm_view_personal_data)
    normal_user_member_group.add_permission(perm_modify_personal_data)
    normal_user_member_group.add_permission(perm_view_paskanmarja_dummies)
    normal_user_member_group.add_permission(perm_edit_paskanmarja_dummies)
    normal_user_member_group.add_permission(perm_view_ports)
    normal_user_member_group.add_permission(perm_edit_paskanmarja_ports)

    logger.info("User permissions created")

    sync_global_permissions()

    db.session.commit()

