from pip.req import parse_requirements
from setuptools import setup, find_packages

setup(
    name='renki-core',
    version='1.0a0.dev66',
    description='Renki service management core server module',
    author='Kapsi Internet-kayttajat ry',
    author_email='renki@kapsi.fi',
    url='https://renki.kapsi.fi',
    classifiers=[
        'Development Status :: 2 - Pre-Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Build Tools',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3.4',
        'Programming Language :: Python :: 3.5',
    ],
    keywords='renki management administration',
    install_requires=[
        str(ir.req) if ir.req is not None else ''
        for ir in parse_requirements('./requirements.txt', session=False)
    ],
    packages=find_packages(),
    namespace_packages=['renki'],
    entry_points={
        'console_scripts': [
            'renki-manage = renki.core.manage:main',
            'renki-core = renki.core.server:main'
        ]
    },
)
