from renki.core.lib.auth.permissions import GlobalPermission

# Permission for changing password of user
ChangePassword = GlobalPermission('change_password', 'Change user\'s password')

# Permission required for members so that they can view their personal data
ViewPersonalData = GlobalPermission('view_personal_data', 'View member\'s personal data')

# Permission required for members so that they can modify their personal data
EditPersonalData = GlobalPermission('edit_personal_data', 'Modify member\'s personal data')

# Permission required for renkisrv users to be able to poll tickets from core
SrvFetchTickets = GlobalPermission('handle_service_tickets', 'Fetch tickets for SRV to do')

# List permissions
ViewPermissions = GlobalPermission('view_permissions', 'View permissions')

# Change permissions - ie. name
EditPermissions = GlobalPermission('edit_permissions', 'Modify permissions')

# Permissions related to viewing and modifying permissions of permission groups
ViewUserPermissionGroups = GlobalPermission('view_user_permission_groups', 'View user permission groups')
EditUserPermissionGroups = GlobalPermission('edit_user_permission_groups', 'Edit user permission groups')

ViewMemberPermissionGroups = GlobalPermission('view_member_permission_groups', 'View member permission groups')
EditMemberPermissionGroups = GlobalPermission('edit_member_permission_groups', 'Edit member permission groups')

ViewUserMemberPermissionGroups = GlobalPermission('view_user_member_permission_groups',
                                                  'View user to member permission groups')
EditUserMemberPermissionGroups = GlobalPermission('edit_user_member_permission_groups',
                                                  'Modify user to member permission groups')

# Permissions related to managing users - members and relations between those
ViewUsers = GlobalPermission('view_users', 'View users')
EditUsers = GlobalPermission('edit_users', 'Edit users')

ViewMembers = GlobalPermission('view_members', 'View members')
EditMembers = GlobalPermission('edit_members', 'Edit members')

ViewUserMembers = GlobalPermission('view_user_members', 'View user members')
EditUserMembers = GlobalPermission('edit_user_members', 'Edit user members')

ViewServices = GlobalPermission('view_services', 'View services')
EditServices = GlobalPermission('edit_services', 'Edit services')

ViewServers = GlobalPermission('view_servers', 'View servers')
EditServers = GlobalPermission('edit_servers', 'Edit servers')
