# Renki migrations - generated by Renki 0.0.1 on 2016-06-22 20:14:46.556732
# initial : Create initial tables
import sqlalchemy as sa
import sqlalchemy_utils.types as ext

version = 1


def upgrade(op):
    op.create_table('unix_users_history',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.Column('version', sa.Integer(), autoincrement=False, nullable=False),
                    sa.Column('changed', sa.DateTime(), nullable=True),
                    sa.PrimaryKeyConstraint('id', 'version')
                    )
    op.create_table('unix_users',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('name', sa.Unicode(), nullable=False),
                    sa.Column('member_id', sa.Integer(), nullable=True),
                    sa.Column('version', sa.Integer(), nullable=False),
                    sa.ForeignKeyConstraint(['member_id'], ['members.id'], ),
                    sa.PrimaryKeyConstraint('id'),
                    sa.UniqueConstraint('name')
                    )
    op.create_table('unix_user_limits',
                    sa.Column('limits_id', sa.Integer(), nullable=False),
                    sa.Column('unix_user_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['limits_id'], ['limits.id'], ),
                    sa.ForeignKeyConstraint(['unix_user_id'], ['unix_users.id'], ),
                    sa.PrimaryKeyConstraint('limits_id')
                    )
    op.create_table('unix_user_tickets',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('unix_user_id', sa.Integer(), nullable=True),
                    sa.ForeignKeyConstraint(['id'], ['tickets.id'], ),
                    sa.ForeignKeyConstraint(['unix_user_id'], ['unix_users.id'], ),
                    sa.PrimaryKeyConstraint('id')
                    )


def downgrade(op):
    op.drop_table('unix_user_tickets')
    op.drop_table('unix_user_limits')
    op.drop_table('unix_users')
    op.drop_table('unix_users_history')
