from sqlalchemy import Column, Integer, ForeignKey, Unicode
from sqlalchemy.orm import relationship

from renki.core.lib.history_meta import Versioned
from renki.core.lib.database.tables import register_table
from renki.core.lib.database.table import RenkiTable
from renki.core.lib.auth.db import Limits
from renki.core.lib.communication.ticket_tables import Ticket


class UnixUser(RenkiTable, Versioned):
    __tablename__ = 'unix_users'
    id = Column('id', Integer, nullable=False, primary_key=True)
    name = Column('name', Unicode, nullable=False, unique=True)
    member_id = Column('member_id', Integer, ForeignKey('members.id'), nullable=True)
    member = relationship('Member', backref='unix_users')

    def validate(self):
        return True

    @classmethod
    def get_ticket_type(cls):
        return 'unix_user'

register_table(UnixUser)


class UnixUserLimits(Limits):
    __tablename__ = 'unix_user_limits'
    limits_id = Column(Integer, ForeignKey('limits.id'), primary_key=True)
    unix_user_id = Column('unix_user_id', Integer, ForeignKey('unix_users.id'))
    unix_user = relationship(UnixUser)

    __mapper_args__ = {
        'polymorphic_identity': 'unix_user_limits',
    }

register_table(UnixUserLimits)


class UnixUserTicket(Ticket):
    __tablename__ = 'unix_user_tickets'
    id = Column(Integer, ForeignKey('tickets.id'), primary_key=True)
    unix_user_id = Column('unix_user_id', Integer, ForeignKey('unix_users.id'))
    unix_user = relationship(UnixUser)

    __mapper_args__ = {
        'polymorphic_identity': 'unix_user_tickets',
    }

register_table(UnixUserTicket)
