import logging

from renki.core.lib.utils import ok as ret_ok, forbidden as ret_denied
from renki.core.lib.renkiapi import renkiapi
from renki.core.lib.auth.permissions import GlobalPermission
from renki.core.lib.database.table import db
from renki.core.lib.blueprints import add_blueprint
from renki.modules.unix_user.core.unix_user_tables import UnixUser

blueprint = add_blueprint('unix_users', __name__)


logger = logging.getLogger('module_unix_user')

ViewUnixUsers = GlobalPermission('view_unix_users', "View all unix users")
EditUnixUsers = GlobalPermission('edit_unix_users', "Edit all unix users")


@renkiapi('GET', '/unix_users', blueprint=blueprint)
def unix_users_index(identity):
    if not identity.has_permission(ViewUnixUsers):
        return ret_denied()

    unix_users = []
    for unix_user in UnixUser.query.all():
        unix_users.append({
            'id': unix_user.id,
            'name': unix_user.name,
            'memberId': unix_user.member_id
        })

    return ret_ok(unix_users)


@renkiapi('POST', '/unix_users',
          json={
              'type': 'object',
              'properties': {
                  'id': {'type': 'integer'},
                  'name': {'type': 'string'},
                  'memberId': {'type': 'integer'}
              },
              'required': ['id', 'name', 'memberId'],
              'additionalProperties': False
          }, blueprint=blueprint)
def unix_users_add(identity, data):
    if not identity.has_permission(EditUnixUsers):
        return ret_denied()

    id = int(data['id'])
    name = data['name']
    member_id = int(data['memberId'])

    unix_user = UnixUser()
    unix_user.id = id
    unix_user.name = name
    unix_user.member_id = member_id
    unix_user.save()

    db.session.commit()

    return ret_ok()
