from renki.common.utilities.settings import Settings

settings = Settings(
    ('debug', {'fields': ['-d', '--debug'], 'type': bool, 'default': False,
               'help': 'Set this true to enable debugging mode.'}),
    ('name', {'fields': ['-n', '--name'], 'type': str, 'required': True,
              'help': 'Name of the server instance.'}),
    ('modules', {'fields': ['-m', '--modules'], 'type': str, 'required': True,
                 'help': 'Renki modules to load.'}),
    ('core_host', {'fields': ['-h', '--core-host'], 'type': str, 'required': True,
                   'help': 'Address to the Renki Core instance.'}),
    ('username', {'fields': ['-u', '--username'], 'type': str, 'required': True,
                  'help': 'Username for authentication.'}),
    ('password', {'fields': ['-p', '--password'], 'type': str, 'required': True,
                  'help': 'Password for authentication.'})
)
